IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO]') AND type in (N'U'))
begin
	CREATE TABLE [dbo].[EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO](
		[CD_EMP] [int] NOT NULL,
		[CD_GRUPO] [int] NOT NULL,
		[CD_PROD] [int] NOT NULL,
		[DT_ATUALIZACAO] [datetime] NOT NULL,
		[ATUALIZADO] [int] NOT NULL,
	 CONSTRAINT [PK_EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_GRUPO] ASC,
		[CD_PROD] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO_EST_PROD_PRECIFICACAO_PRECO] FOREIGN KEY([CD_EMP], [CD_GRUPO], [CD_PROD])
	REFERENCES [dbo].[EST_PROD_PRECIFICACAO_PRECO] ([CD_EMP], [CD_GRUPO], [CD_PROD])
	ON UPDATE CASCADE
	ON DELETE CASCADE

	ALTER TABLE [dbo].[EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO] CHECK CONSTRAINT [FK_EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO_EST_PROD_PRECIFICACAO_PRECO]

	ALTER TABLE [dbo].[EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO] ADD  CONSTRAINT [DF_EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].[EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO] ADD  CONSTRAINT [DF_EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

	ALTER TABLE [dbo].[EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO] ADD  CONSTRAINT [DF_EST_PROD_PRECIFICACAO_PRECO_ATUALIZACAO_ATUALIZADO]  DEFAULT ((0)) FOR [ATUALIZADO]
end

